#include <iostream>
#include <unordered_map>
#include <vector>
#include <algorithm>

using namespace std;

bool sort_logic(pair<long,long> a, pair<long,long> b) {
    if (a.second!=b.second) return a.second > b.second;
    return a.first < b.first;
}

bool two_sum(long target, long ignore_val, const vector<std::pair<long, long>>& v) {
    unordered_map<long, long> lookup;
    for (const auto& e:v) {
        long val = e.first;
        if (val == ignore_val) continue;
        long complement = target - val;
        if (lookup.count(complement) && complement != ignore_val) return true;
        lookup[val] = e.second;
    }
    return false;
}

int main() {
    unordered_map<long, long> hash;
	long n, a[100000], z=0;
	cin>>n;
	for (long i=0; i<n; i++) {
		cin>>a[i];
		z+=a[i];
		if (!hash[a[i]]) hash[a[i]]=0;
		hash[a[i]]++;
	}
    vector<pair<long, long>> v(hash.begin(), hash.end());
    sort(v.begin(), v.end(), sort_logic);
    pair<long,long> best;
    bool check = true;
    for (long i=0; i<n; i++) {
        best = v[i];
        check = two_sum(z, best.first, v);
        if (check) break;
    }
    cout<<best.second;
	return 0;
}